/*
 * Decompiled with CFR 0.152.
 */
package com.imavis.tlc3000.network.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.imavis.tlc3000.network.client.CamTableModel;
import com.imavis.tlc3000.network.client.Consts;
import com.imavis.tlc3000.network.client.Dialogs;
import com.imavis.tlc3000.network.client.UDPClient;
import com.imavis.tlc3000.network.client.entities.Camera;
import com.imavis.tlc3000.network.client.entities.Response;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UDPServer
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(UDPServer.class.getName());
    private final CamTableModel camTableModel;
    private final UDPClient udpClient;
    private final DatagramSocket socket;
    private final byte[] data = new byte[1024];
    private final JsonParser parser = new JsonParser();
    private final Gson gson = new Gson();
    private final Set<String> versionWarnings = new HashSet<String>();
    private final Set<String> responseIds = new HashSet<String>();

    public UDPServer(CamTableModel camTableModel, UDPClient udpClient) throws SocketException {
        this.camTableModel = Objects.requireNonNull(camTableModel);
        this.udpClient = Objects.requireNonNull(udpClient);
        try {
            this.socket = new DatagramSocket(7078);
            this.socket.setBroadcast(true);
            LOGGER.log(Level.INFO, "listening on udp port {0}", 7078);
        }
        catch (SocketException ex) {
            LOGGER.log(Level.SEVERE, "error creating udp server", ex);
            Dialogs.showMessage("error.bind", Dialogs.MessageType.ERROR, 7078);
            throw ex;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    DatagramPacket packet = new DatagramPacket(this.data, this.data.length);
                    this.socket.receive(packet);
                    String message = new String(packet.getData(), packet.getOffset(), packet.getLength(), StandardCharsets.UTF_8);
                    LOGGER.log(Level.FINE, "received: {0}", message);
                    Camera camera = this.parse(message, "TLC_3000_PONG ", Camera.class);
                    Response response = this.parse(message, "TLC_3000_RESP ", Response.class);
                    if (camera != null) {
                        EventQueue.invokeLater(() -> this.camTableModel.addCamera(camera));
                    }
                    if (response == null || !Consts.CLIENT_ID.equals(response.getClient())) continue;
                    this.manageResponse(response);
                }
            }
            catch (IOException | RuntimeException ex) {
                LOGGER.log(Level.WARNING, "error receiving a packet", ex);
                continue;
            }
            break;
        }
    }

    private void manageResponse(Response response) {
        if (this.responseIds.contains(response.getId())) {
            LOGGER.finest("response discarded");
            return;
        }
        this.responseIds.add(response.getId());
        this.udpClient.sendPing();
        if (response.isError()) {
            String key;
            switch (response.getResult()) {
                case "invalid_password": {
                    key = "message.invalid_password";
                    break;
                }
                case "invalid_configuration": {
                    key = "message.invalid_configuration";
                    break;
                }
                case "expired_key": {
                    key = "message.invalid_key";
                    break;
                }
                default: {
                    key = "message.unexpected_error";
                }
            }
            Dialogs.showMessage(key, Dialogs.MessageType.ERROR, response.getSerial());
        } else {
            switch (response.getResult()) {
                case "done": {
                    Dialogs.showMessage("message.done", Dialogs.MessageType.INFO, response.getSerial());
                    break;
                }
                case "done_env_trouble": {
                    Dialogs.showMessage("message.done_env_trouble", Dialogs.MessageType.WARNING, response.getSerial());
                }
            }
        }
    }

    private <T> T parse(String message, String prefix, Class<T> contentClass) {
        if (message.startsWith(prefix)) {
            String jsonStr = message.substring(prefix.length());
            JsonElement json = this.parser.parse(jsonStr);
            Integer version = UDPServer.getProtocolVersion(json);
            if (version == null) {
                LOGGER.log(Level.WARNING, "invalid or error message: {0}", message);
            } else if (version < 2) {
                this.unsupportedVersion("error.too_old_version");
            } else if (version > 2) {
                this.unsupportedVersion("error.too_new_version");
            } else {
                return this.gson.fromJson(json, contentClass);
            }
        }
        return null;
    }

    private static Integer getProtocolVersion(JsonElement json) {
        try {
            return json.getAsJsonObject().get("v").getAsInt();
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    private void unsupportedVersion(String messageKey) {
        if (!this.versionWarnings.contains(messageKey)) {
            this.versionWarnings.add(messageKey);
            Dialogs.showMessage(messageKey, Dialogs.MessageType.WARNING, new Object[0]);
        }
    }
}

