/*
 * Decompiled with CFR 0.152.
 */
package com.imavis.tlc3000.network.client;

import com.google.gson.Gson;
import com.imavis.tlc3000.network.client.Consts;
import com.imavis.tlc3000.network.client.Dialogs;
import com.imavis.tlc3000.network.client.Passwords;
import com.imavis.tlc3000.network.client.SendingAddress;
import com.imavis.tlc3000.network.client.entities.Request;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.IllegalBlockSizeException;

public class UDPClient {
    private static final Logger LOGGER = Logger.getLogger(UDPClient.class.getName());
    private static final String PING = "TLC_3000_PING";
    private final DatagramSocket socket;
    private final Gson gson = new Gson();

    public UDPClient(SendingAddress sendingAddress) throws SocketException, UnknownHostException {
        try {
            this.socket = new DatagramSocket(new InetSocketAddress(sendingAddress.getAddress(), 0));
            this.socket.setBroadcast(true);
            this.socket.connect(InetAddress.getByName("255.255.255.255"), 7079);
            LOGGER.log(Level.INFO, "sending on udp port {0}", 7079);
        }
        catch (SocketException | UnknownHostException ex) {
            LOGGER.log(Level.SEVERE, "error creating udp client", ex);
            Dialogs.showMessage("error.unexpected", Dialogs.MessageType.ERROR, new Object[0]);
            throw ex;
        }
    }

    public void sendPing() {
        this.send(PING, null);
    }

    public void sendRequest(int version, String serial, String ip, String env_ip, String netmask, String gateway, String dns, char[] password, String key) {
        try {
            String encPassword = Passwords.encryptPassword(password, key);
            Request request = new Request();
            request.setV(version);
            request.setClient(Consts.CLIENT_ID);
            request.setSerial(Objects.requireNonNull(serial));
            request.setIp(Objects.requireNonNull(ip));
            request.setEnv_ip(env_ip);
            request.setNetmask(Objects.requireNonNull(netmask));
            request.setGateway(Objects.requireNonNull(gateway));
            request.setDns(Objects.requireNonNull(dns));
            request.setPassword(encPassword);
            String message = "TLC_3000_SET " + this.gson.toJson(request);
            this.send(message, serial);
        }
        catch (InvalidKeyException | InvalidKeySpecException ex) {
            LOGGER.log(Level.WARNING, "invalid key", ex);
            Dialogs.showMessage("message.invalid_key", Dialogs.MessageType.ERROR, serial);
        }
        catch (IllegalBlockSizeException ex) {
            LOGGER.log(Level.INFO, "too long password", ex);
            Dialogs.showMessage("message.invalid_password", Dialogs.MessageType.ERROR, serial);
        }
    }

    private void send(String message, String serial) {
        LOGGER.log(Level.FINE, "sending: {0}", message);
        try {
            byte[] buf = message.getBytes(StandardCharsets.UTF_8);
            if (buf.length <= 500) {
                this.socket.send(new DatagramPacket(buf, buf.length));
            } else if (serial != null) {
                LOGGER.log(Level.INFO, "too long packet: {0}", buf.length);
                Dialogs.showMessage("message.invalid_configuration", Dialogs.MessageType.ERROR, serial);
            } else {
                LOGGER.log(Level.WARNING, "too long packet: {0}", buf.length);
            }
        }
        catch (IOException | RuntimeException ex) {
            LOGGER.log(Level.WARNING, "error sending a packet", ex);
            Dialogs.showMessage("error.send", Dialogs.MessageType.ERROR, new Object[0]);
        }
    }
}

