/*
 * Decompiled with CFR 0.152.
 */
package com.imavis.tlc3000.network.client;

import com.imavis.tlc3000.network.client.DialogListeners;
import com.imavis.tlc3000.network.client.Dialogs;
import com.imavis.tlc3000.network.client.MainFrame;
import com.imavis.tlc3000.network.client.PasswordDialog;
import com.imavis.tlc3000.network.client.UDPClient;
import com.imavis.tlc3000.network.client.entities.Camera;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public final class SetDialog
extends JDialog {
    private static final int WAITING_TIMEOUT = 15000;
    private final MainFrame mainFrame;
    private final Camera camera;
    private final UDPClient udpClient;
    private final boolean env;
    private JButton cancelButton;
    private JTextField dnsField;
    private JLabel dnsLabel;
    private JTextField envIpField;
    private JLabel envIpLabel;
    private JTextField gatewayField;
    private JLabel gatewayLabel;
    private JTextField ipField;
    private JLabel ipLabel;
    private JTextField netmaskField;
    private JLabel netmaskLabel;
    private JButton sendButton;

    public SetDialog(MainFrame mainFrame, Camera camera, UDPClient udpClient) {
        super(mainFrame, Dialogs.getTitleText(camera.getSerial()), true);
        this.mainFrame = Objects.requireNonNull(mainFrame);
        this.camera = Objects.requireNonNull(camera);
        this.udpClient = Objects.requireNonNull(udpClient);
        this.env = camera.getEnv_ip() != null;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.sendButton);
        if (this.env) {
            new DialogListeners(this.sendButton, this.ipField, this.envIpField).addFields(this.ipField, this.envIpField, this.dnsField);
        } else {
            new DialogListeners(this.sendButton).addFields(this.ipField, this.netmaskField, this.gatewayField, this.dnsField);
        }
    }

    private void initComponents() {
        this.ipLabel = new JLabel();
        this.ipField = new JTextField();
        this.envIpLabel = new JLabel();
        this.envIpField = new JTextField();
        this.netmaskLabel = new JLabel();
        this.netmaskField = new JTextField();
        this.gatewayLabel = new JLabel();
        this.gatewayField = new JTextField();
        this.dnsLabel = new JLabel();
        this.dnsField = new JTextField();
        this.sendButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        ResourceBundle bundle = ResourceBundle.getBundle("com/imavis/tlc3000/network/client/Bundle");
        this.ipLabel.setText(bundle.getString("label.ip"));
        this.ipField.setText(this.camera.getIp());
        this.envIpLabel.setText(bundle.getString("label.env_ip"));
        this.envIpField.setText(this.camera.getEnv_ip());
        this.envIpField.setEnabled(this.env);
        this.netmaskLabel.setText(bundle.getString("label.netmask"));
        this.netmaskField.setText(this.camera.getNetmask());
        this.gatewayLabel.setText(bundle.getString("label.gateway"));
        this.gatewayField.setText(this.camera.getGateway());
        this.dnsLabel.setText(bundle.getString("label.dns"));
        this.dnsField.setText(this.camera.getDns());
        this.sendButton.setText(bundle.getString("button.send"));
        this.sendButton.setEnabled(false);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetDialog.this.sendButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(bundle.getString("button.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ipLabel, -1, -1, Short.MAX_VALUE).addComponent(this.netmaskLabel, -1, -1, Short.MAX_VALUE).addComponent(this.gatewayLabel, -1, 70, Short.MAX_VALUE).addComponent(this.dnsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.envIpLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ipField, -1, 323, Short.MAX_VALUE).addComponent(this.netmaskField).addComponent(this.gatewayField).addComponent(this.dnsField).addComponent(this.envIpField))).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.sendButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.sendButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ipLabel).addComponent(this.ipField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.envIpLabel).addComponent(this.envIpField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.netmaskLabel).addComponent(this.netmaskField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gatewayLabel).addComponent(this.gatewayField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dnsLabel).addComponent(this.dnsField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.sendButton)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.cancelButton, this.sendButton);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void sendButtonActionPerformed(ActionEvent evt) {
        PasswordDialog dialog = new PasswordDialog(this);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        char[] password = dialog.getPassword();
        if (password != null) {
            this.dispose();
            Dialogs.showWaitingMessage("message.waiting", 15000, () -> {
                Dialogs.showMessage("message.timeout", Dialogs.MessageType.ERROR, new Object[0]);
                this.mainFrame.scan();
            });
            this.udpClient.sendRequest(this.camera.getV(), this.camera.getSerial(), this.ipField.getText(), this.env ? this.envIpField.getText() : null, this.netmaskField.getText(), this.gatewayField.getText(), this.dnsField.getText(), password, this.camera.getKey());
        }
    }
}

