/*
 * Decompiled with CFR 0.152.
 */
package com.imavis.tlc3000.network.client;

import java.awt.Color;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DialogListeners {
    private static Listener listener;
    private final JButton sendButton;
    private JTextField fieldIp;
    private JTextField fieldIpEnv;
    private final String fieldInitialIp;
    private final String fieldInitialIpEnv;

    public void addFields(JTextField ... fields) {
        listener = new Listener(this.sendButton, this.fieldIp, this.fieldIpEnv, this.fieldInitialIp, this.fieldInitialIpEnv, fields);
        Arrays.asList(fields).forEach(field -> field.getDocument().addDocumentListener(listener));
        this.enableIfValidFields();
        this.markFieldsAsInvalid();
    }

    public DialogListeners(JButton button, JTextField fieldIp, JTextField fieldIpEnv) {
        this.sendButton = button;
        this.fieldIp = fieldIp;
        this.fieldIpEnv = fieldIpEnv;
        this.fieldInitialIp = fieldIp.getText();
        this.fieldInitialIpEnv = fieldIpEnv.getText();
    }

    public DialogListeners(JButton button) {
        this.sendButton = button;
        this.fieldInitialIp = null;
        this.fieldInitialIpEnv = null;
    }

    public void enableIfValidFields() {
        DialogListeners.listener.enableButton();
    }

    public void markFieldsAsInvalid() {
        DialogListeners.listener.markFieldsAsInvalid(this.fieldIp, this.fieldInitialIpEnv);
        DialogListeners.listener.markFieldsAsInvalid(this.fieldIpEnv, this.fieldInitialIp);
    }

    private static class Listener
    implements DocumentListener {
        private final JButton button;
        private final JTextField[] fields;
        private final JTextField fieldIp;
        private final JTextField fieldIpEnv;
        private final String fieldInitialIp;
        private final String fieldInitialIpEnv;

        Listener(JButton button, JTextField fieldIp, JTextField fieldIpEnv, String fieldInitialIp, String fieldInitialIpEnv, JTextField[] fields) {
            this.button = button;
            this.fields = fields;
            this.fieldIp = fieldIp;
            this.fieldIpEnv = fieldIpEnv;
            this.fieldInitialIp = fieldInitialIp;
            this.fieldInitialIpEnv = fieldInitialIpEnv;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.enableButton();
            this.markFieldsAsInvalid(this.fieldIp, this.fieldInitialIpEnv);
            this.markFieldsAsInvalid(this.fieldIpEnv, this.fieldInitialIp);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.enableButton();
            this.markFieldsAsInvalid(this.fieldIp, this.fieldInitialIpEnv);
            this.markFieldsAsInvalid(this.fieldIpEnv, this.fieldInitialIp);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.enableButton();
            this.markFieldsAsInvalid(this.fieldIp, this.fieldInitialIpEnv);
            this.markFieldsAsInvalid(this.fieldIpEnv, this.fieldInitialIp);
        }

        private void enableButton() {
            boolean enable = true;
            for (JTextField field : this.fields) {
                if (field instanceof JPasswordField) {
                    JPasswordField passwordField = (JPasswordField)field;
                    enable &= passwordField.getPassword().length > 0;
                    continue;
                }
                enable &= !field.getText().isEmpty();
            }
            this.button.setEnabled(enable &= !this.compareFieldWithInitialValue(this.fieldIp, this.fieldInitialIpEnv) && !this.compareFieldWithInitialValue(this.fieldIpEnv, this.fieldInitialIp));
        }

        private boolean compareFieldWithInitialValue(JTextField field, String initialVal) {
            if (field == null) {
                return false;
            }
            return field.getText().equals(initialVal);
        }

        private void markFieldsAsInvalid(JTextField field, String initialValue) {
            if (field == null) {
                return;
            }
            if (this.compareFieldWithInitialValue(field, initialValue)) {
                field.setForeground(Color.RED);
            } else {
                field.setForeground(Color.BLACK);
            }
        }
    }
}

